<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								<?php echo e(__('reports.attendance_title')); ?>

							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-between">
									<div class="report-btns">
										<a href="<?php echo e(route('reports.attendance', ['type' => 'csv'] )); ?>"
											class="btn btn-default">
											<i class="fas fa-file-csv"></i>
											<?php echo e(__('reports.export')); ?>

										</a>
										<a href="<?php echo e(route('reports.attendance', ['type' => 'print'] )); ?>" rel="noopener"
											target="_blank" class="btn btn-default">
											<i class="fas fa-print"></i>
											<?php echo e(__('reports.print')); ?>

										</a>
									</div>
									<form class="w-50" method="post" action="<?php echo e(route('reports.attendance')); ?>">
										<?php echo e(csrf_field()); ?>

										<div class="row no-gutters">
											<div class="col-md-6 pr-2">
												<select class="form-control" name="search" required>
													<option value="all" <?php echo e($keyword=="all" ? "selected" : ""); ?>>All
													</option>
													<option value="today" <?php echo e($keyword=="today" ? "selected" : ""); ?>>
														Today</option>
													<option value="this_week" <?php echo e($keyword=="this_week" ? "selected" : ""); ?>>
														This Week
													</option>
													<option value="this_month" <?php echo e($keyword=="this_month" ? "selected"
														: ""); ?>>
														This Month
													</option>
													<option value="last_month" <?php echo e($keyword=="last_month" ? "selected"
														: ""); ?>>
														Last Month
													</option>
													<option value="last_three_months" <?php echo e($keyword=="last_three_months"
														? "selected" : ""); ?>>
														Last 3 Months
													</option>
													<option value="last_six_months" <?php echo e($keyword=="last_six_months"
														? "selected" : ""); ?>>
														Last 6 Months
													</option>
													<option value="this_year" <?php echo e($keyword=="this_year" ? "selected" : ""); ?>>
														This Year
													</option>
													<option value="last_year" <?php echo e($keyword=="last_year" ? "selected" : ""); ?>>
														Last Year
													</option>
												</select>
											</div>
											<div class="col-md-6">
												<div class="input-group mb-3">
													<select class="form-control select-member" name="member">
														<option value="all" <?php echo e($member=="all" ? "selected" : ""); ?>>
															All Member
														</option>
														<?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleMember): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($singleMember->id); ?>" <?php echo e($member==$singleMember->id ? "selected" : ""); ?>>
															<?php echo e($singleMember->name); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
													<div class="input-group-append">
														<button class="btn btn-primary" type="submit">
															<i class="fas fa-search"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap fixed-width-td"><?php echo e(__('reports.th_photo')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_name')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_reg_no')); ?></th>
													<th class="nowrap"><?php echo e(__('reports.th_membership_type')); ?></th>
													<th><?php echo e(__('reports.th_date')); ?></th>
													<th><?php echo e(__('reports.th_day')); ?></th>
													<th><?php echo e(__('reports.th_status')); ?></th>
													<th class="nowrap fixed-width-td"><?php echo e(__('reports.th_taken_by')); ?>

													</th>
												</tr>
											</thead>
											<tbody>
												<?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td class="align-middle">
														<div class="img-circle elevation-2 profile-image"
															style="background-image: url('<?php echo e(img_url($attendance->member->profile_picture)); ?>');">
														</div>
													</td>
													<td class="align-middle nowrap">
														<?php echo e($attendance->member->name); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($attendance->member->reg_no); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($attendance->member->latest_membership->membership_type->name); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e(format_date($attendance->attendance_date)); ?>

													</td>
													<td class="align-middle">
														<?php echo e(day_name($attendance->attendance_date)); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo attendance_status_badge($attendance->status); ?>

													</td>
													<td class="align-middle nowrap">
														<?php echo e($attendance->user->name); ?>

													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php if(count($attendances) == 0): ?>
												<tr>
													<td colspan="11">
														<p class="text-center mb-0"><?php echo e(__('reports.no_record_found')); ?>

														</p>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										<?php if($paginate): ?>
										<?php echo e($attendances->links()); ?>

										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-script'); ?>
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-member').select2({
			theme: 'bootstrap4'
		});
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/reports/attendance.blade.php ENDPATH**/ ?>